﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using Game;

// 	Summary
// 		* GameObject texture의 scroll animation.

namespace GameUtility
{
	/*
		Animation scroll direction.
 	*/
	public enum AnimationScrollDirection
	{
		Up,
		Down,
		Left,
		Right,
	}

	/*
		Animation scroll
 	*/
	public class AnimationScroll : MonoBehaviour
	{

		public float Speed	= 0.5f;
		public AnimationScrollDirection Direction = AnimationScrollDirection.Up;

		public GameManager m_GameManager;

		private bool m_Pause;

		// Use this for initialization
		void Start ()
		{
			m_Pause	= false;
		}
	
		// Update is called once per frame
		void Update ()
		{
			if (m_Pause == false) {
				float coefficientX	= 0f;
				float coefficientY	= 0f;

				if (AnimationScrollDirection.Up == Direction) {
					coefficientY = -1f;
				} else if (AnimationScrollDirection.Down == Direction) {
					coefficientY = 1f;
				} else if (AnimationScrollDirection.Left == Direction) {
					coefficientX = 0.1f;
				} else if (AnimationScrollDirection.Right == Direction) {
					coefficientX = -0.1f;
				}

				Vector2 offset	= new Vector2 (Time.time * Speed * coefficientX, Time.time * Speed * coefficientY);

				GetComponent<Renderer> ().material.mainTextureOffset	= offset;
			}
		}

		/*
			Animation을 중지한다.
	 	*/
		public void Pause ()
		{
			m_Pause	= true;
		}

		/*
			Animation을 재개한다.
	 	*/
		public void Resume ()
		{
			m_Pause = false;
		}
	}
}